import { ConfigLogContext } from "@zwave-js/config";
import { NodeLogContext } from "@zwave-js/core";
import { SerialLogContext } from "@zwave-js/serial";
import { ClientsController, Logger } from "./server.js";
import { ControllerLogContext, DriverLogContext, Driver } from "zwave-js";
export type LogContexts = ConfigLogContext | ControllerLogContext | DriverLogContext | NodeLogContext | SerialLogContext;
export declare class LoggingEventForwarder {
    private clients;
    private driver;
    private logger;
    /**
     * Only load this once the driver is ready.
     *
     * @param clients
     * @param driver
     */
    private serverTransport?;
    constructor(clients: ClientsController, driver: Driver, logger: Logger);
    get started(): boolean;
    start(filter?: Partial<LogContexts>): void;
    stop(): void;
    restartIfNeeded(): void;
}
