export var ErrorCode;
(function (ErrorCode) {
    ErrorCode["unknownError"] = "unknown_error";
    ErrorCode["unknownCommand"] = "unknown_command";
    ErrorCode["nodeNotFound"] = "node_not_found";
    ErrorCode["endpointNotFound"] = "endpoint_not_found";
    ErrorCode["virtualEndpointNotFound"] = "virtual_endpoint_not_found";
    ErrorCode["schemaIncompatible"] = "schema_incompatible";
    ErrorCode["zwaveError"] = "zwave_error";
    ErrorCode["inclusionPhaseNotInProgress"] = "inclusion_phase_not_in_progress";
    ErrorCode["inclusionAlreadyInProgress"] = "inclusion_already_in_progress";
    ErrorCode["invalidParamsPassedToCommand"] = "invalid_params_passed_to_command";
    ErrorCode["noLongerSupported"] = "no_longer_supported";
})(ErrorCode || (ErrorCode = {}));
export class BaseError extends Error {
    // @ts-ignore
    errorCode;
    constructor(message) {
        super(message);
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, BaseError.prototype);
        Object.getPrototypeOf(this).name = "BaseError";
    }
}
export class UnknownError extends BaseError {
    error;
    errorCode = ErrorCode.unknownError;
    constructor(error) {
        super();
        this.error = error;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, UnknownError.prototype);
        Object.getPrototypeOf(this).name = "UnknownError";
    }
}
export class UnknownCommandError extends BaseError {
    command;
    errorCode = ErrorCode.unknownCommand;
    constructor(command) {
        super();
        this.command = command;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, UnknownCommandError.prototype);
        Object.getPrototypeOf(this).name = "UnknownCommandError";
    }
}
export class NodeNotFoundError extends BaseError {
    nodeId;
    errorCode = ErrorCode.nodeNotFound;
    constructor(nodeId) {
        super();
        this.nodeId = nodeId;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, NodeNotFoundError.prototype);
        Object.getPrototypeOf(this).name = "NodeNotFoundError";
    }
}
export class SchemaIncompatibleError extends BaseError {
    schemaId;
    errorCode = ErrorCode.schemaIncompatible;
    constructor(schemaId) {
        super();
        this.schemaId = schemaId;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, SchemaIncompatibleError.prototype);
        Object.getPrototypeOf(this).name = "SchemaIncompatibleError";
    }
}
export class VirtualEndpointNotFoundError extends BaseError {
    index;
    nodeIDs;
    broadcast;
    errorCode = ErrorCode.virtualEndpointNotFound;
    constructor(index, nodeIDs, broadcast) {
        super();
        this.index = index;
        this.nodeIDs = nodeIDs;
        this.broadcast = broadcast;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, VirtualEndpointNotFoundError.prototype);
        Object.getPrototypeOf(this).name = "VirtualEndpointNotFoundError";
    }
}
export class EndpointNotFoundError extends BaseError {
    nodeId;
    index;
    errorCode = ErrorCode.endpointNotFound;
    constructor(nodeId, index) {
        super();
        this.nodeId = nodeId;
        this.index = index;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, EndpointNotFoundError.prototype);
        Object.getPrototypeOf(this).name = "EndpointNotFoundError";
    }
}
export class InclusionPhaseNotInProgressError extends BaseError {
    phase;
    errorCode = ErrorCode.inclusionPhaseNotInProgress;
    constructor(phase) {
        super();
        this.phase = phase;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, InclusionPhaseNotInProgressError.prototype);
        Object.getPrototypeOf(this).name = "InclusionPhaseNotInProgressError";
    }
}
export class InclusionAlreadyInProgressError extends BaseError {
    errorCode = ErrorCode.inclusionAlreadyInProgress;
    constructor() {
        super();
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, InclusionAlreadyInProgressError.prototype);
        Object.getPrototypeOf(this).name = "InclusionAlreadyInProgressError";
    }
}
export class InvalidParamsPassedToCommandError extends BaseError {
    errorCode = ErrorCode.invalidParamsPassedToCommand;
    constructor(message) {
        super(message);
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, InvalidParamsPassedToCommandError.prototype);
        Object.getPrototypeOf(this).name = "InvalidParamsPassedToCommandError";
    }
}
export class NoLongerSupportedError extends BaseError {
    errorCode = ErrorCode.noLongerSupported;
    constructor(message) {
        super(message +
            " If you are using an application that integrates with Z-Wave JS and you receive this error, you may need to update the application.");
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, NoLongerSupportedError.prototype);
        Object.getPrototypeOf(this).name = "NoLongerSupportedError";
    }
}
