import Transport from "winston-transport";
import { MESSAGE as messageSymbol } from "triple-beam";
import { createDefaultTransportFormat } from "@zwave-js/core/bindings/log/node";
export class LoggingEventForwarder {
    clients;
    driver;
    logger;
    /**
     * Only load this once the driver is ready.
     *
     * @param clients
     * @param driver
     */
    serverTransport;
    constructor(clients, driver, logger) {
        this.clients = clients;
        this.driver = driver;
        this.logger = logger;
    }
    get started() {
        return this.serverTransport !== undefined;
    }
    start(filter) {
        var { transports, level } = this.driver.getLogConfig();
        // Set the log level before attaching the transport
        this.logger.info("Starting logging event forwarder at " + level + " level");
        this.serverTransport = new WebSocketLogTransport(level, this.clients, filter);
        transports = transports || [];
        transports.push(this.serverTransport);
        this.driver.updateLogConfig({ transports });
    }
    stop() {
        this.logger.info("Stopping logging event forwarder");
        const transports = this.driver
            .getLogConfig()
            .transports.filter((transport) => transport !== this.serverTransport);
        this.driver.updateLogConfig({ transports });
        delete this.serverTransport;
    }
    restartIfNeeded() {
        var { level } = this.driver.getLogConfig();
        if (this.started && this.serverTransport?.level != level) {
            this.stop();
            this.start();
        }
    }
}
class WebSocketLogTransport extends Transport {
    clients;
    filter;
    constructor(level, clients, filter) {
        super({
            format: createDefaultTransportFormat(false, false),
            level,
        });
        this.clients = clients;
        this.filter = filter;
    }
    log(info, next) {
        const context = info.context;
        // If there is no filter or if all key/value pairs match from filter, forward
        // the message to the client
        if (!this.filter ||
            Object.entries(this.filter).every(([key, value]) => key in context && context[key] === value)) {
            // Forward logs on to clients that are currently
            // receiving logs
            this.clients.clients
                .filter((cl) => cl.receiveLogs && cl.isConnected)
                .forEach((client) => client.sendEvent({
                source: "driver",
                event: "logging",
                formattedMessage: info[messageSymbol],
                ...info,
            }));
        }
        next();
    }
}
