import { EventEmitter } from "events";
class MockController extends EventEmitter {
    homeId = 1;
    nodes = new Map();
}
class MockDriver extends EventEmitter {
    controller = new MockController();
    ready = true;
    statisticsEnabled = true;
    async start() {
        this.emit("driver ready");
    }
    getLogConfig() {
        return {
            enabled: true,
            level: "debug",
            transports: [],
        };
    }
    updateLogConfig(config) { }
    updateUserAgent(additionalUserAgentComponents) { }
    updateOptions(options) { }
    async destroy() { }
}
export const createMockDriver = () => new MockDriver();
