export declare class AsyncQueue<T> implements AsyncIterable<T> {
    /** Adds one or more items onto the queue */
    add(...items: T[]): void;
    /**
     * Removes an item from the queue if it was not processed yet.
     * The return value indicates whether the item was removed.
     */
    remove(item: T): boolean;
    get length(): number;
    private backlog;
    private listeners;
    private ended;
    /** Ends the queue after it has been drained */
    end(): void;
    /** Ends the queue and discards all pending items */
    abort(): void;
    [Symbol.asyncIterator](): AsyncIterator<T>;
}
//# sourceMappingURL=AsyncQueue.d.ts.map