import { Readable } from 'stream';
import type { ParserStreamOptions, Commit } from 'conventional-commits-parser';
import { type GetSemverTagsParams, type GetCommitsParams, ConventionalGitClient, packagePrefix } from '@conventional-changelog/git-client';
import { type Options as WriterOptions, type Context, type Details } from 'conventional-changelog-writer';
import { type UnknownPresetCreatorParams, type PresetParams, type PresetModuleLoader } from 'conventional-changelog-preset-loader';
import type { HostedGitInfo, PackageTransform, Options, Preset } from './types.js';
export { packagePrefix };
/**
 * Conventional changelog generator
 */
export declare class ConventionalChangelog {
    private readonly gitClient;
    private params;
    constructor(cwdOrGitClient?: string | ConventionalGitClient);
    private composeParams;
    private finalizeContext;
    private finalizeWriterOptions;
    private getSemverTags;
    private getCommits;
    private transformCommits;
    private getPackageJson;
    /**
     * Load configs from a preset
     * @param preset
     * @param loader - Preset module loader, if not provided, will use default loader
     * @returns this
     */
    loadPreset<PresetCreatorParams extends UnknownPresetCreatorParams = UnknownPresetCreatorParams>(preset: PresetParams<PresetCreatorParams>, loader?: PresetModuleLoader): this;
    /**
     * Set the config directly
     * @param config - Config object
     * @returns this
     */
    config(config: Preset | Promise<Preset>): this;
    /**
     * Find package.json and read it
     * @param transform - Optional transform function
     * @returns this
     */
    readPackage(transform?: PackageTransform): this;
    /**
     * Read package.json from a specified path
     * @param path - Path to package.json
     * @param transform - Optional transform function
     * @returns this
     */
    readPackage(path?: string, transform?: PackageTransform): this;
    /**
     * Set package.json data
     * @param pkg - Package.json data
     * @returns this
     */
    package(pkg: Record<string, unknown>): this;
    /**
     * Read repository info from the current git repository
     * @returns this
     */
    readRepository(): this;
    /**
     * Set repository info
     * @param infoOrGitUrl - Hosted git info or git url
     * @returns this
     */
    repository(infoOrGitUrl: string | Partial<HostedGitInfo>): this;
    /**
     * Set conventional-changelog options
     * @param options - Generator options
     * @returns this
     */
    options(options: Options): this;
    /**
     * Set writer context data
     * @param context - Writer context data
     * @returns this
     */
    context(context: Context): this;
    /**
     * Set params to get semver tags
     * @param params - Params to get the last semver tag
     * @returns this
     */
    tags(params: GetSemverTagsParams): this;
    /**
     * Set params to get commits
     * @param params - Params to get commits since last release
     * @param parserOptions - Parser options
     * @returns this
     */
    commits(params: GetCommitsParams, parserOptions?: ParserStreamOptions): this;
    /**
     * Set writer options
     * @param params - Writer options
     * @returns this
     */
    writer(params: WriterOptions): this;
    /**
     * Generate changelog
     * @param includeDetails - Generate data objects instead of strings
     * @returns Changelog generator
     */
    write(includeDetails?: false): AsyncGenerator<string, void>;
    /**
     * Generate changelog data objects
     * @param includeDetails - Generate data objects instead of strings
     */
    write(includeDetails: true): AsyncGenerator<Details<Commit>, void>;
    /**
     * Generate changelog
     * @param includeDetails - Generate data objects instead of strings
     * @returns Changelog generator
     */
    write(includeDetails?: boolean): AsyncGenerator<string | Details<Commit>, void>;
    /**
     * Generate changelog to stream
     * @param includeDetails - Generate data objects instead of strings
     * @returns Changelog stream
     */
    writeStream(includeDetails?: boolean): Readable;
}
//# sourceMappingURL=ConventionalChangelog.d.ts.map