import { packagePrefix } from '@conventional-changelog/git-client';
export function parseOptions(options) {
    const result = {};
    if (typeof options.append === 'boolean') {
        result.append = options.append;
    }
    if (options.firstRelease === true) {
        result.releaseCount = 0;
    }
    else if (typeof options.releaseCount === 'number') {
        result.releaseCount = options.releaseCount;
    }
    if (typeof options.outputUnreleased === 'boolean') {
        result.outputUnreleased = options.outputUnreleased;
    }
    if (!Object.keys(result).length) {
        return null;
    }
    return result;
}
export function parseTagsOptions(options) {
    const result = {};
    if (typeof options.tagPrefix === 'string') {
        result.prefix = options.tagPrefix;
    }
    if (typeof options.lernaPackage === 'string') {
        result.prefix = packagePrefix(options.lernaPackage);
    }
    if (options.skipUnstable) {
        result.skipUnstable = true;
    }
    if (!Object.keys(result).length) {
        return null;
    }
    return result;
}
export function parseCommitsOptions(options) {
    const result = {};
    if (typeof options.commitPath === 'string') {
        result.path = options.commitPath;
    }
    if (!Object.keys(result).length) {
        return null;
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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