import fs from 'fs';
import readline from 'readline';
export async function* splitStream(stream, separator) {
    let chunk;
    let payload;
    let buffer = '';
    for await (chunk of stream) {
        buffer += chunk.toString();
        if (buffer.includes(separator)) {
            payload = buffer.split(separator);
            buffer = payload.pop() || '';
            yield* payload;
        }
    }
    if (buffer) {
        yield buffer;
    }
}
export async function* readRawCommitsFromFiles(files, separator) {
    for (const file of files) {
        try {
            yield* splitStream(fs.createReadStream(file), separator);
        }
        catch (err) {
            console.warn(`Failed to read file ${file}:\n  ${err}`);
        }
    }
}
export async function* readRawCommitsFromLine(separator) {
    const rl = readline.createInterface({
        input: process.stdin,
        output: process.stdout,
        terminal: true
    });
    let line = '';
    let commit = '';
    for await (line of rl) {
        commit += `${line}\n`;
        if (!commit.includes(separator)) {
            return;
        }
        yield commit;
        commit = '';
    }
}
export function readRawCommitsFromStdin(separator) {
    return splitStream(process.stdin, separator);
}
const JSON_STREAM_OPEN = '[\n';
const JSON_STREAM_SEPARATOR = '\n,\n';
const JSON_STREAM_CLOSE = '\n]\n';
export async function* stringify(commits) {
    let jsonStreamOpened = false;
    yield JSON_STREAM_OPEN;
    for await (const commit of commits) {
        if (jsonStreamOpened) {
            yield JSON_STREAM_SEPARATOR;
        }
        yield JSON.stringify(commit);
        jsonStreamOpened = true;
    }
    yield JSON_STREAM_CLOSE;
}
//# sourceMappingURL=data:application/json;base64,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