"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageIsDevDependency = void 0;
const path_1 = require("./path");
const fs_1 = require("fs");
function packageIsDevDependency({ appPath, patchDetails, }) {
    const packageJsonPath = path_1.join(appPath, "package.json");
    if (!fs_1.existsSync(packageJsonPath)) {
        return false;
    }
    const { devDependencies } = require(packageJsonPath);
    return Boolean(devDependencies && devDependencies[patchDetails.packageNames[0]]);
}
exports.packageIsDevDependency = packageIsDevDependency;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFja2FnZUlzRGV2RGVwZW5kZW5jeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9wYWNrYWdlSXNEZXZEZXBlbmRlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLGlDQUE2QjtBQUM3QiwyQkFBK0I7QUFFL0IsU0FBZ0Isc0JBQXNCLENBQUMsRUFDckMsT0FBTyxFQUNQLFlBQVksR0FJYjtJQUNDLE1BQU0sZUFBZSxHQUFHLFdBQUksQ0FBQyxPQUFPLEVBQUUsY0FBYyxDQUFDLENBQUE7SUFDckQsSUFBSSxDQUFDLGVBQVUsQ0FBQyxlQUFlLENBQUMsRUFBRTtRQUNoQyxPQUFPLEtBQUssQ0FBQTtLQUNiO0lBQ0QsTUFBTSxFQUFFLGVBQWUsRUFBRSxHQUFHLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQTtJQUNwRCxPQUFPLE9BQU8sQ0FDWixlQUFlLElBQUksZUFBZSxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FDakUsQ0FBQTtBQUNILENBQUM7QUFmRCx3REFlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBhdGNoZWRQYWNrYWdlRGV0YWlscyB9IGZyb20gXCIuL1BhY2thZ2VEZXRhaWxzXCJcbmltcG9ydCB7IGpvaW4gfSBmcm9tIFwiLi9wYXRoXCJcbmltcG9ydCB7IGV4aXN0c1N5bmMgfSBmcm9tIFwiZnNcIlxuXG5leHBvcnQgZnVuY3Rpb24gcGFja2FnZUlzRGV2RGVwZW5kZW5jeSh7XG4gIGFwcFBhdGgsXG4gIHBhdGNoRGV0YWlscyxcbn06IHtcbiAgYXBwUGF0aDogc3RyaW5nXG4gIHBhdGNoRGV0YWlsczogUGF0Y2hlZFBhY2thZ2VEZXRhaWxzXG59KSB7XG4gIGNvbnN0IHBhY2thZ2VKc29uUGF0aCA9IGpvaW4oYXBwUGF0aCwgXCJwYWNrYWdlLmpzb25cIilcbiAgaWYgKCFleGlzdHNTeW5jKHBhY2thZ2VKc29uUGF0aCkpIHtcbiAgICByZXR1cm4gZmFsc2VcbiAgfVxuICBjb25zdCB7IGRldkRlcGVuZGVuY2llcyB9ID0gcmVxdWlyZShwYWNrYWdlSnNvblBhdGgpXG4gIHJldHVybiBCb29sZWFuKFxuICAgIGRldkRlcGVuZGVuY2llcyAmJiBkZXZEZXBlbmRlbmNpZXNbcGF0Y2hEZXRhaWxzLnBhY2thZ2VOYW1lc1swXV0sXG4gIClcbn1cbiJdfQ==