import type { ZWaveSerialStream } from "@zwave-js/serial";
import { MockPort } from "@zwave-js/serial/mock";
import type { FileSystem } from "@zwave-js/shared/bindings";
import { Driver } from "./Driver.js";
import type { PartialZWaveOptions } from "./ZWaveOptions.js";
export interface CreateAndStartDriverWithMockPortResult {
    driver: Driver;
    continueStartup: () => void;
    mockPort: MockPort;
    serial: ZWaveSerialStream;
}
export interface CreateAndStartDriverWithMockPortOptions {
}
/** Creates a real driver instance with a mocked serial port to enable end to end tests */
export declare function createAndStartDriverWithMockPort(options?: Partial<CreateAndStartDriverWithMockPortOptions> & PartialZWaveOptions): Promise<CreateAndStartDriverWithMockPortResult>;
export type CreateAndStartTestingDriverResult = Omit<CreateAndStartDriverWithMockPortResult, "continueStartup">;
export interface CreateAndStartTestingDriverOptions {
    beforeStartup: (mockPort: MockPort, serial: ZWaveSerialStream) => void | Promise<void>;
    /**
     * Whether the controller identification should be skipped (default: false).
     * If not, a Mock controller must be available on the serial port.
     */
    skipControllerIdentification?: boolean;
    /**
     * Whether the node interview should be skipped (default: false).
     * If not, a Mock controller and/or mock nodes must be available on the serial port.
     */
    skipNodeInterview?: boolean;
    /**
     * Set this to true to skip checking if the controller is in bootloader, serial API, or CLI mode (default: true)
     */
    skipFirmwareIdentification?: boolean;
    /**
     * Whether configuration files should be loaded (default: true)
     */
    loadConfiguration?: boolean;
    portAddress: string;
    fs?: FileSystem;
}
export declare function createAndStartTestingDriver(options?: Partial<CreateAndStartTestingDriverOptions> & PartialZWaveOptions): Promise<CreateAndStartTestingDriverResult>;
//# sourceMappingURL=DriverMock.d.ts.map