import type { Message } from "@zwave-js/serial";
import { type DeferredPromise } from "alcalzone-shared/deferred-promise";
import { SortedList } from "alcalzone-shared/sorted-list";
import type { Transaction } from "./Transaction.js";
export interface TransactionQueueOptions {
    name: string;
    mayStartNextTransaction: (transaction: Transaction) => boolean;
}
/**
 * The transaction queue offers an async-iterable interface to a list of transactions.
 */
export declare class TransactionQueue implements AsyncIterable<Transaction> {
    constructor(options?: Partial<TransactionQueueOptions>);
    readonly name: string;
    private mayStartNextTransaction;
    readonly transactions: SortedList<Transaction>;
    currentTransaction: Transaction | undefined;
    add(...items: Transaction[]): void;
    remove(...items: Transaction[]): void;
    find(predicate: (item: Transaction) => boolean): Transaction | undefined;
    finalizeTransaction(): void;
    get length(): number;
    /** Causes the queue to re-evaluate whether the next transaction may be started */
    trigger(): void;
    private listeners;
    private ended;
    /** Ends the queue after it has been drained */
    end(): void;
    /** Ends the queue and discards all pending items */
    abort(): void;
    [Symbol.asyncIterator](): AsyncIterator<Transaction>;
}
export interface SerialAPIQueueItem extends Disposable {
    msg: Message;
    transactionSource?: string;
    result: DeferredPromise<Message | undefined>;
}
//# sourceMappingURL=Queue.d.ts.map