import type { ZWaveError } from "@zwave-js/core";
import { type Task as WaddleTask, type TaskBuilder as WaddleTaskBuilder, TaskInterruptBehavior, TaskPriority, type TaskReturnType, TaskScheduler as WaddleTaskScheduler } from "@zwave-js/waddle";
export type TaskTag = {
    id: "rebuild-routes";
} | {
    id: "rebuild-node-routes";
    nodeId: number;
} | {
    id: "firmware-update-ota";
    nodeId: number;
} | {
    id: "inclusion";
} | {
    id: "exclusion";
} | {
    id: "remove-failed-node";
    nodeId: number;
} | {
    id: "replace-failed-node";
    nodeId: number;
};
export type Task<T> = WaddleTask<T, TaskTag, ZWaveError>;
export type TaskBuilder<T> = WaddleTaskBuilder<T, TaskTag>;
export declare class TaskScheduler extends WaddleTaskScheduler<TaskTag, ZWaveError> {
}
export { TaskInterruptBehavior, TaskPriority };
export type { TaskReturnType };
//# sourceMappingURL=Task.d.ts.map