"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWaveOptions_exports = {};
__export(ZWaveOptions_exports, {
  driverPresets: () => driverPresets
});
module.exports = __toCommonJS(ZWaveOptions_exports);
const driverPresets = Object.freeze({
  /**
   * Increases several timeouts to be able to deal with controllers
   * and/or nodes that have severe trouble communicating.
   */
  SAFE_MODE: {
    timeouts: {
      // 500 series controllers that take long to respond instead of delaying the callback
      response: 6e4,
      // Any controller having trouble reaching a node
      sendDataAbort: 6e4,
      sendDataCallback: 65e3,
      // Slow nodes taking long to respond
      report: 1e4,
      nonce: 2e4
    },
    attempts: {
      // Increase communication attempts with nodes to their maximum
      sendData: 5,
      sendDataJammed: 10,
      nodeInterview: 10
    }
  },
  /**
   * Disables the unresponsive controller recovery to be able to deal with controllers
   * that frequently become unresponsive for seemingly no reason.
   */
  NO_CONTROLLER_RECOVERY: {
    features: {
      unresponsiveControllerRecovery: false
    }
  },
  /**
   * @deprecated
   * This used to prevent the driver from enabling the watchdog on 700 series controllers.
   * This is now the default behavior, so this option is no longer necessary.
   */
  NO_WATCHDOG: {
    features: {
      watchdog: false
    }
  },
  /**
   * Sends battery powered nodes to sleep more quickly in order to save battery.
   */
  BATTERY_SAVE: {
    timeouts: {
      sendToSleep: 100
    }
  },
  /**
   * Sends battery powered nodes to sleep less quickly to give applications
   * more time between interactions.
   */
  AWAKE_LONGER: {
    timeouts: {
      sendToSleep: 1e3
    }
  }
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  driverPresets
});
//# sourceMappingURL=ZWaveOptions.js.map
