"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssociationGroupInformationCC_exports = {};
__export(AssociationGroupInformationCC_exports, {
  handleAGICommandListGet: () => handleAGICommandListGet,
  handleAGIInfoGet: () => handleAGIInfoGet,
  handleAGINameGet: () => handleAGINameGet,
  handleAssociationSupportedGroupingsGet: () => handleAssociationSupportedGroupingsGet
});
module.exports = __toCommonJS(AssociationGroupInformationCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
async function handleAGINameGet(ctx, node, command) {
  if (command.groupId !== 1) {
    return;
  }
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses["Association Group Information"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportGroupName(1, "Lifeline");
}
__name(handleAGINameGet, "handleAGINameGet");
async function handleAGIInfoGet(ctx, node, command) {
  if (!command.listMode && command.groupId !== 1) {
    return;
  }
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses["Association Group Information"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportGroupInfo({
    isListMode: command.listMode ?? false,
    hasDynamicInfo: false,
    groups: [
      {
        groupId: 1,
        eventCode: 0,
        // ignored anyways
        profile: import_cc.AssociationGroupInfoProfile["General: Lifeline"],
        mode: 0
        // ignored anyways
      }
    ]
  });
}
__name(handleAGIInfoGet, "handleAGIInfoGet");
async function handleAGICommandListGet(ctx, node, command) {
  if (command.groupId !== 1) {
    return;
  }
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses["Association Group Information"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportCommands(command.groupId, /* @__PURE__ */ new Map([
    [
      import_core.CommandClasses["Device Reset Locally"],
      [import_cc.DeviceResetLocallyCommand.Notification]
    ]
  ]));
}
__name(handleAGICommandListGet, "handleAGICommandListGet");
async function handleAssociationSupportedGroupingsGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Association, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportGroupCount(1);
}
__name(handleAssociationSupportedGroupingsGet, "handleAssociationSupportedGroupingsGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleAGICommandListGet,
  handleAGIInfoGet,
  handleAGINameGet,
  handleAssociationSupportedGroupingsGet
});
//# sourceMappingURL=AssociationGroupInformationCC.js.map
