"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ManufacturerSpecificCC_exports = {};
__export(ManufacturerSpecificCC_exports, {
  handleManufacturerSpecificGet: () => handleManufacturerSpecificGet
});
module.exports = __toCommonJS(ManufacturerSpecificCC_exports);
var import_core = require("@zwave-js/core");
async function handleManufacturerSpecificGet(ctx, node, command, vendorInfo) {
  const api = node.createAPI(import_core.CommandClasses["Manufacturer Specific"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.sendReport({
    // Reserved manufacturer ID, definitely invalid!
    manufacturerId: vendorInfo?.manufacturerId ?? 65535,
    productType: vendorInfo?.productType ?? 65535,
    productId: vendorInfo?.productId ?? 65535
  });
}
__name(handleManufacturerSpecificGet, "handleManufacturerSpecificGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleManufacturerSpecificGet
});
//# sourceMappingURL=ManufacturerSpecificCC.js.map
