"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultiChannelAssociationCC_exports = {};
__export(MultiChannelAssociationCC_exports, {
  handleMultiChannelAssociationGet: () => handleMultiChannelAssociationGet,
  handleMultiChannelAssociationRemove: () => handleMultiChannelAssociationRemove,
  handleMultiChannelAssociationSet: () => handleMultiChannelAssociationSet,
  handleMultiChannelAssociationSupportedGroupingsGet: () => handleMultiChannelAssociationSupportedGroupingsGet
});
module.exports = __toCommonJS(MultiChannelAssociationCC_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("./_shared.js");
async function handleMultiChannelAssociationSupportedGroupingsGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses["Multi Channel Association"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportGroupCount(1);
}
__name(handleMultiChannelAssociationSupportedGroupingsGet, "handleMultiChannelAssociationSupportedGroupingsGet");
async function handleMultiChannelAssociationGet(ctx, controller, node, command) {
  const groupId = 1;
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses["Multi Channel Association"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  const nodeIds = controller.associations.filter((a) => a.endpoint == void 0).map((a) => a.nodeId) ?? [];
  const endpoints = controller.associations.filter((a) => a.endpoint != void 0).map(({ nodeId, endpoint: endpoint2 }) => ({
    nodeId,
    endpoint: endpoint2
  })) ?? [];
  await api.sendReport({
    groupId,
    maxNodes: import_shared.MAX_ASSOCIATIONS,
    nodeIds,
    endpoints,
    reportsToFollow: 0
  });
}
__name(handleMultiChannelAssociationGet, "handleMultiChannelAssociationGet");
function handleMultiChannelAssociationSet(ctx, controller, node, command) {
  if (command.groupId !== 1) {
    throw new import_core.ZWaveError(`Multi Channel Association group ${command.groupId} is not supported.`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  const newNodeIdAssociations = command.nodeIds.filter((newNodeId) => !controller.associations.some(({ nodeId, endpoint }) => endpoint === void 0 && nodeId === newNodeId)).map((nodeId) => ({ nodeId }));
  const newEndpointAssociations = command.endpoints.flatMap(({ nodeId, endpoint }) => {
    if (typeof endpoint === "number") {
      return { nodeId, endpoint };
    } else {
      return endpoint.map((e) => ({ nodeId, endpoint: e }));
    }
  }).filter(({ nodeId: newNodeId, endpoint: newEndpoint }) => !controller.associations.some(({ nodeId, endpoint }) => nodeId === newNodeId && endpoint === newEndpoint));
  const associations = [...controller.associations];
  associations.push(...newNodeIdAssociations, ...newEndpointAssociations);
  if (associations.length > import_shared.MAX_ASSOCIATIONS) {
    throw new import_core.ZWaveError(`Multi Channel Association group ${command.groupId} is full`, import_core.ZWaveErrorCodes.CC_OperationFailed);
  }
  controller.associations = associations.slice(0, import_shared.MAX_ASSOCIATIONS);
}
__name(handleMultiChannelAssociationSet, "handleMultiChannelAssociationSet");
function handleMultiChannelAssociationRemove(ctx, controller, node, command) {
  if (!!command.groupId && command.groupId !== 1) {
    return;
  }
  if (!command.nodeIds?.length && !command.endpoints?.length) {
    controller.associations = [];
  } else {
    let associations = [...controller.associations];
    if (command.nodeIds?.length) {
      associations = associations.filter(({ nodeId, endpoint }) => endpoint === void 0 && !command.nodeIds.includes(nodeId));
    }
    if (command.endpoints?.length) {
      associations = associations.filter(({ nodeId, endpoint }) => !command.endpoints.some((dest) => dest.nodeId === nodeId && dest.endpoint === endpoint));
    }
    controller.associations = associations;
  }
}
__name(handleMultiChannelAssociationRemove, "handleMultiChannelAssociationRemove");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleMultiChannelAssociationGet,
  handleMultiChannelAssociationRemove,
  handleMultiChannelAssociationSet,
  handleMultiChannelAssociationSupportedGroupingsGet
});
//# sourceMappingURL=MultiChannelAssociationCC.js.map
