"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var VersionCC_exports = {};
__export(VersionCC_exports, {
  handleVersionCapabilitiesGet: () => handleVersionCapabilitiesGet,
  handleVersionCommandClassGet: () => handleVersionCommandClassGet,
  handleVersionGet: () => handleVersionGet
});
module.exports = __toCommonJS(VersionCC_exports);
var import_core = require("@zwave-js/core");
var import_parse = __toESM(require("semver/functions/parse.js"), 1);
var import_Driver = require("../../driver/Driver.js");
async function handleVersionGet(ctx, controller, node, command, vendorInfo) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Version, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  const firmwareVersion1 = (0, import_parse.default)(import_Driver.libVersion, { loose: true });
  await api.sendReport({
    libraryType: import_core.ZWaveLibraryTypes["Static Controller"],
    protocolVersion: controller.protocolVersion,
    firmwareVersions: [
      // Firmware 0 is the Z-Wave chip firmware
      controller.firmwareVersion,
      // Firmware 1 is Z-Wave JS itself
      `${firmwareVersion1.major}.${firmwareVersion1.minor}.${firmwareVersion1.patch}`
    ],
    hardwareVersion: vendorInfo?.hardwareVersion
  });
}
__name(handleVersionGet, "handleVersionGet");
async function handleVersionCommandClassGet(ctx, node, command, reportVersion) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Version, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportCCVersion(command.requestedCC, reportVersion);
}
__name(handleVersionCommandClassGet, "handleVersionCommandClassGet");
async function handleVersionCapabilitiesGet(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  const api = endpoint.createAPI(import_core.CommandClasses.Version, false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  });
  await api.reportCapabilities();
}
__name(handleVersionCapabilitiesGet, "handleVersionCapabilitiesGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleVersionCapabilitiesGet,
  handleVersionCommandClassGet,
  handleVersionGet
});
//# sourceMappingURL=VersionCC.js.map
