"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HealthCheck_exports = {};
__export(HealthCheck_exports, {
  formatLifelineHealthCheckRound: () => formatLifelineHealthCheckRound,
  formatLifelineHealthCheckSummary: () => formatLifelineHealthCheckSummary,
  formatRouteHealthCheckRound: () => formatRouteHealthCheckRound,
  formatRouteHealthCheckSummary: () => formatRouteHealthCheckSummary,
  healthCheckRatingToWord: () => healthCheckRatingToWord,
  healthCheckTestFrameCount: () => healthCheckTestFrameCount
});
module.exports = __toCommonJS(HealthCheck_exports);
var import_cc = require("@zwave-js/cc");
var import_shared = require("@zwave-js/shared");
const healthCheckTestFrameCount = 10;
function healthCheckRatingToWord(rating) {
  return rating >= 10 ? "perfect" : rating >= 6 ? "good" : rating >= 4 ? "acceptable" : rating >= 1 ? "bad" : "dead";
}
__name(healthCheckRatingToWord, "healthCheckRatingToWord");
function formatLifelineHealthCheckRound(round, numRounds, result) {
  const ret = [
    `\xB7 round ${round.toString().padStart(Math.floor(Math.log10(numRounds) + 1), " ")} - rating: ${result.rating} (${healthCheckRatingToWord(result.rating)})`,
    `  failed pings \u2192 node:             ${result.failedPingsNode}/${healthCheckTestFrameCount}`,
    `  max. latency:                    ${result.latency.toFixed(1)} ms`,
    result.routeChanges != void 0 ? `  route changes:                   ${result.routeChanges}` : "",
    result.snrMargin != void 0 ? `  SNR margin:                      ${result.snrMargin} dBm` : "",
    result.failedPingsController != void 0 ? `  failed pings \u2192 controller:       ${result.failedPingsController}/${healthCheckTestFrameCount} at normal power` : result.minPowerlevel != void 0 ? `  min. node powerlevel w/o errors: ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, result.minPowerlevel)}` : ""
  ].filter((line) => !!line).join("\n");
  return ret;
}
__name(formatLifelineHealthCheckRound, "formatLifelineHealthCheckRound");
function formatLifelineHealthCheckSummary(summary) {
  let ret = `
rating:                   ${summary.rating} (${healthCheckRatingToWord(summary.rating)})`;
  const numNeighbors = summary.results.at(-1).numNeighbors;
  if (numNeighbors != void 0) {
    ret += `
no. of routing neighbors: ${summary.results.at(-1).numNeighbors}`;
  }
  ret += `

Check rounds:
${summary.results.map((r, i) => formatLifelineHealthCheckRound(i + 1, summary.results.length, r)).join("\n \n")}`;
  return ret.trim();
}
__name(formatLifelineHealthCheckSummary, "formatLifelineHealthCheckSummary");
function formatRouteHealthCheckRound(sourceNodeId, targetNodeId, round, numRounds, result) {
  const ret = [
    `\xB7 round ${round.toString().padStart(Math.floor(Math.log10(numRounds) + 1), " ")} - rating: ${result.rating} (${healthCheckRatingToWord(result.rating)})`,
    result.failedPingsToTarget != void 0 ? `  failed pings ${sourceNodeId} \u2192 ${targetNodeId}:      ${result.failedPingsToTarget}/${healthCheckTestFrameCount}` : result.minPowerlevelSource != void 0 ? `  Node ${sourceNodeId} min. powerlevel w/o errors: ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, result.minPowerlevelSource)}` : "",
    result.failedPingsToSource != void 0 ? `  failed pings ${targetNodeId} \u2192 ${sourceNodeId}:      ${result.failedPingsToSource}/${healthCheckTestFrameCount}` : result.minPowerlevelTarget != void 0 ? `  Node ${targetNodeId} min. powerlevel w/o errors: ${(0, import_shared.getEnumMemberName)(import_cc.Powerlevel, result.minPowerlevelTarget)}` : ""
  ].filter((line) => !!line).join("\n");
  return ret;
}
__name(formatRouteHealthCheckRound, "formatRouteHealthCheckRound");
function formatRouteHealthCheckSummary(sourceNodeId, targetNodeId, summary) {
  let ret = `
rating:                   ${summary.rating} (${healthCheckRatingToWord(summary.rating)})`;
  const numNeighbors = summary.results.at(-1).numNeighbors;
  if (numNeighbors != void 0) {
    ret += `
no. of routing neighbors: ${summary.results.at(-1).numNeighbors}`;
  }
  ret += `

Check rounds:
${summary.results.map((r, i) => formatRouteHealthCheckRound(sourceNodeId, targetNodeId, i + 1, summary.results.length, r)).join("\n \n")}`;
  return ret.trim();
}
__name(formatRouteHealthCheckSummary, "formatRouteHealthCheckSummary");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  formatLifelineHealthCheckRound,
  formatLifelineHealthCheckSummary,
  formatRouteHealthCheckRound,
  formatRouteHealthCheckSummary,
  healthCheckRatingToWord,
  healthCheckTestFrameCount
});
//# sourceMappingURL=HealthCheck.js.map
