"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DeviceConfig_exports = {};
__export(DeviceConfig_exports, {
  DeviceConfigMixin: () => DeviceConfigMixin
});
module.exports = __toCommonJS(DeviceConfig_exports);
var import_ConfigurationCC = require("@zwave-js/cc/ConfigurationCC");
var import_config = require("@zwave-js/config");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_NetworkCache = require("../../driver/NetworkCache.js");
var import_FirmwareUpdate = require("./70_FirmwareUpdate.js");
class DeviceConfigMixin extends import_FirmwareUpdate.FirmwareUpdateMixin {
  static {
    __name(this, "DeviceConfigMixin");
  }
  _deviceConfig;
  /**
   * Contains additional information about this node, loaded from a config file
   */
  get deviceConfig() {
    return this._deviceConfig;
  }
  set deviceConfig(value) {
    this._deviceConfig = value;
  }
  /**
   * Returns the manufacturer/brand name defined in the device configuration,
   * or looks it up from the manufacturer database if no config is available
   */
  get manufacturer() {
    if (this._deviceConfig)
      return this._deviceConfig.manufacturer;
    if (this.manufacturerId != void 0) {
      return this.driver.lookupManufacturer(this.manufacturerId);
    }
  }
  /**
   * Returns the device label defined in the device configuration.
   */
  get label() {
    return this._deviceConfig?.label;
  }
  get deviceDatabaseUrl() {
    if (this.manufacturerId != void 0 && this.productType != void 0 && this.productId != void 0) {
      const manufacturerId = (0, import_shared.formatId)(this.manufacturerId);
      const productType = (0, import_shared.formatId)(this.productType);
      const productId = (0, import_shared.formatId)(this.productId);
      const firmwareVersion = this.firmwareVersion || "0.0";
      return `https://devices.zwave-js.io/?jumpTo=${manufacturerId}:${productType}:${productId}:${firmwareVersion}`;
    }
  }
  /**
   * Returns whether the device config for this node has changed since the last interview.
   * If it has, the node likely needs to be re-interviewed for the changes to be picked up.
   */
  hasDeviceConfigChanged() {
    if (this.interviewStage !== import_core.InterviewStage.Complete)
      return import_core.NOT_KNOWN;
    if (this.isControllerNode)
      return false;
    if (this.cachedDeviceConfigHash == void 0) {
      return this.deviceConfig == void 0 ? false : import_core.NOT_KNOWN;
    }
    if (this._currentDeviceConfigHash) {
      return !import_config.DeviceConfig.areHashesEqual(this._currentDeviceConfigHash, this.cachedDeviceConfigHash);
    }
    return true;
  }
  /**
   * @internal
   * The hash of the device config that was applied during the last interview.
   */
  get cachedDeviceConfigHash() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).deviceConfigHash);
  }
  set cachedDeviceConfigHash(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).deviceConfigHash, value);
  }
  _currentDeviceConfigHash;
  /**
   * @internal
   * The hash of the currently used device config
   */
  get currentDeviceConfigHash() {
    return this._currentDeviceConfigHash;
  }
  set currentDeviceConfigHash(value) {
    this._currentDeviceConfigHash = value;
  }
  /**
   * Loads the device configuration for this node from a config file
   */
  async loadDeviceConfig() {
    if (this.manufacturerId == void 0 || this.productType == void 0 || this.productId == void 0) {
      return;
    }
    this.deviceConfig = await this.driver.configManager.lookupDevice(this.manufacturerId, this.productType, this.productId, this.firmwareVersion);
    if (!this.deviceConfig) {
      this.driver.controllerLog.logNode(this.id, "No device config found", "warn");
      return;
    }
    const versionPrefix = import_shared.Bytes.from("$v", "utf8");
    const hasVersionPrefix = !!this.cachedDeviceConfigHash && import_shared.Bytes.view(this.cachedDeviceConfigHash.subarray(0, 2)).equals(versionPrefix);
    let cachedHashVersion;
    if (this.cachedDeviceConfigHash?.length === 16 && !hasVersionPrefix) {
      cachedHashVersion = 0;
      this._currentDeviceConfigHash = await this.deviceConfig.getHash(0);
    } else if (this.cachedDeviceConfigHash?.length === 32 && !hasVersionPrefix) {
      cachedHashVersion = 1;
      this._currentDeviceConfigHash = await this.deviceConfig.getHash(1);
    } else {
      this._currentDeviceConfigHash = await this.deviceConfig.getHash();
      if (this.cachedDeviceConfigHash) {
        const versionString = import_shared.Bytes.view(this.cachedDeviceConfigHash).toString("utf8").match(/^\$v(\d+)\$/)?.[1];
        if (versionString) {
          cachedHashVersion = parseInt(versionString, 10);
        }
      }
      cachedHashVersion ??= 0;
    }
    if (this.interviewStage === import_core.InterviewStage.Complete) {
      if (cachedHashVersion < import_config.DeviceConfig.maxHashVersion && this.hasDeviceConfigChanged() === false) {
        this.cachedDeviceConfigHash = await this.deviceConfig.getHash();
      }
      for (const ep of this.getAllEndpoints()) {
        (0, import_ConfigurationCC.refreshMetadataStringsFromConfigFile)(this.driver, this.id, ep.index);
      }
    }
    this.driver.controllerLog.logNode(this.id, `${this.deviceConfig.isEmbedded ? "Embedded" : "User-provided"} device config loaded`);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DeviceConfigMixin
});
//# sourceMappingURL=80_DeviceConfig.js.map
