"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Basic_exports = {};
__export(Basic_exports, {
  BasicCCBehaviors: () => BasicCCBehaviors
});
module.exports = __toCommonJS(Basic_exports);
var import_BasicCC = require("@zwave-js/cc/BasicCC");
var import_core = require("@zwave-js/core");
const STATE_KEY_PREFIX = "Basic_";
const StateKeys = {
  currentValue: `${STATE_KEY_PREFIX}currentValue`
};
const respondToBasicGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_BasicCC.BasicCCGet) {
      if (!self.implementedCCs.get(import_core.CommandClasses.Basic)?.isSupported) {
        return;
      }
      const cc = new import_BasicCC.BasicCCReport({
        nodeId: controller.ownNodeId,
        currentValue: self.state.get(StateKeys.currentValue) ?? 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToBasicSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_BasicCC.BasicCCSet) {
      self.state.set(StateKeys.currentValue, receivedCC.targetValue);
      return { action: "ok" };
    }
  }
};
const BasicCCBehaviors = [respondToBasicGet, respondToBasicSet];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BasicCCBehaviors
});
//# sourceMappingURL=Basic.js.map
