"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BinarySensor_exports = {};
__export(BinarySensor_exports, {
  BinarySensorCCBehaviors: () => BinarySensorCCBehaviors
});
module.exports = __toCommonJS(BinarySensor_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  supportedSensorTypes: []
};
const respondToBinarySensorSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.BinarySensorCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Binary Sensor"], receivedCC.endpointIndex)
      };
      const cc = new import_cc.BinarySensorCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportedSensorTypes: capabilities.supportedSensorTypes
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToBinarySensorGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.BinarySensorCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Binary Sensor"], receivedCC.endpointIndex)
      };
      let sensorType;
      if (receivedCC.sensorType == void 0 || receivedCC.sensorType === import_cc.BinarySensorType.Any) {
        sensorType = capabilities.supportedSensorTypes[0];
      } else {
        sensorType = receivedCC.sensorType;
      }
      if (sensorType != void 0) {
        const value = capabilities.getValue?.(sensorType) ?? false;
        const cc = new import_cc.BinarySensorCCReport({
          nodeId: controller.ownNodeId,
          type: sensorType,
          value
        });
        return { action: "sendCC", cc };
      }
      return { action: "stop" };
    }
  }
};
const BinarySensorCCBehaviors = [
  respondToBinarySensorSupportedGet,
  respondToBinarySensorGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BinarySensorCCBehaviors
});
//# sourceMappingURL=BinarySensor.js.map
