"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BinarySwitch_exports = {};
__export(BinarySwitch_exports, {
  BinarySwitchCCBehaviors: () => BinarySwitchCCBehaviors
});
module.exports = __toCommonJS(BinarySwitch_exports);
var import_BinarySwitchCC = require("@zwave-js/cc/BinarySwitchCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  defaultValue: false
};
const STATE_KEY_PREFIX = "BinarySwitch_";
const StateKeys = {
  currentValue: `${STATE_KEY_PREFIX}currentValue`
};
const respondToBinarySwitchGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_BinarySwitchCC.BinarySwitchCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Binary Switch"], receivedCC.endpointIndex)
      };
      const cc = new import_BinarySwitchCC.BinarySwitchCCReport({
        nodeId: controller.ownNodeId,
        currentValue: self.state.get(StateKeys.currentValue) ?? capabilities.defaultValue ?? import_core.UNKNOWN_STATE
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToBinarySwitchSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_BinarySwitchCC.BinarySwitchCCSet) {
      self.state.set(StateKeys.currentValue, receivedCC.targetValue);
      return { action: "ok" };
    }
  }
};
const BinarySwitchCCBehaviors = [
  respondToBinarySwitchGet,
  respondToBinarySwitchSet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BinarySwitchCCBehaviors
});
//# sourceMappingURL=BinarySwitch.js.map
