"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ColorSwitch_exports = {};
__export(ColorSwitch_exports, {
  ColorSwitchCCBehaviors: () => ColorSwitchCCBehaviors
});
module.exports = __toCommonJS(ColorSwitch_exports);
var import_cc = require("@zwave-js/cc");
var import_ColorSwitchCC = require("@zwave-js/cc/ColorSwitchCC");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
const defaultCapabilities = {
  colorComponents: {}
};
const STATE_KEY_PREFIX = "ColorSwitch_";
const StateKeys = {
  component: /* @__PURE__ */ __name((component) => `${STATE_KEY_PREFIX}${(0, import_shared.getEnumMemberName)(import_cc.ColorComponent, component)}`, "component")
};
const respondToColorSwitchSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ColorSwitchCC.ColorSwitchCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Color Switch"], receivedCC.endpointIndex)
      };
      const cc = new import_ColorSwitchCC.ColorSwitchCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportedColorComponents: Object.keys(capabilities.colorComponents).map((c) => parseInt(c))
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToColorSwitchSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ColorSwitchCC.ColorSwitchCCSet) {
      for (const [key, value] of Object.entries(receivedCC.colorTable)) {
        const component = import_cc.ColorComponentMap[key];
        self.state.set(StateKeys.component(component), value);
      }
      return { action: "ok" };
    }
  }
};
const respondToColorSwitchGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ColorSwitchCC.ColorSwitchCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Color Switch"], receivedCC.endpointIndex)
      };
      const component = receivedCC.colorComponent;
      if (component in capabilities.colorComponents) {
        const cc = new import_ColorSwitchCC.ColorSwitchCCReport({
          nodeId: controller.ownNodeId,
          colorComponent: component,
          currentValue: self.state.get(StateKeys.component(component)) ?? capabilities.colorComponents[component] ?? 0
        });
        return { action: "sendCC", cc };
      } else {
        return { action: "stop" };
      }
    }
  }
};
const respondToColorSwitchStartLevelChange = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ColorSwitchCC.ColorSwitchCCStartLevelChange) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Color Switch"], receivedCC.endpointIndex)
      };
      const component = receivedCC.colorComponent;
      if (component in capabilities.colorComponents) {
        self.state.set(StateKeys.component(component), receivedCC.direction === "up" ? 255 : 0);
        return { action: "ok" };
      } else {
        return { action: "fail" };
      }
    }
  }
};
const respondToColorSwitchStopLevelChange = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ColorSwitchCC.ColorSwitchCCStopLevelChange) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Color Switch"], receivedCC.endpointIndex)
      };
      const component = receivedCC.colorComponent;
      if (component in capabilities.colorComponents) {
        return { action: "ok" };
      } else {
        return { action: "fail" };
      }
    }
  }
};
const ColorSwitchCCBehaviors = [
  respondToColorSwitchSupportedGet,
  respondToColorSwitchSet,
  respondToColorSwitchGet,
  respondToColorSwitchStartLevelChange,
  respondToColorSwitchStopLevelChange
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ColorSwitchCCBehaviors
});
//# sourceMappingURL=ColorSwitch.js.map
