"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EnergyProduction_exports = {};
__export(EnergyProduction_exports, {
  EnergyProductionCCBehaviors: () => EnergyProductionCCBehaviors
});
module.exports = __toCommonJS(EnergyProduction_exports);
var import_cc = require("@zwave-js/cc");
var import_EnergyProductionCC = require("@zwave-js/cc/EnergyProductionCC");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
const defaultCapabilities = {
  values: {
    Power: {
      value: 0,
      scale: 0
    },
    "Production Total": {
      value: 0,
      scale: 0
    },
    "Production Today": {
      value: 0,
      scale: 0
    },
    "Total Time": {
      value: 0,
      scale: 0
    }
  }
};
const respondToEnergyProductionGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_EnergyProductionCC.EnergyProductionCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Energy Production"], receivedCC.endpointIndex)
      };
      const result = capabilities.values[(0, import_shared.getEnumMemberName)(import_cc.EnergyProductionParameter, receivedCC.parameter)];
      const cc = new import_EnergyProductionCC.EnergyProductionCCReport({
        nodeId: controller.ownNodeId,
        parameter: receivedCC.parameter,
        value: result?.value ?? 0,
        scale: (0, import_cc.getEnergyProductionScale)(receivedCC.parameter, result?.scale ?? 0)
      });
      return { action: "sendCC", cc };
    }
  }
};
const EnergyProductionCCBehaviors = [respondToEnergyProductionGet];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EnergyProductionCCBehaviors
});
//# sourceMappingURL=EnergyProduction.js.map
