"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Meter_exports = {};
__export(Meter_exports, {
  MeterCCBehaviors: () => MeterCCBehaviors,
  defaultCapabilities: () => defaultCapabilities
});
module.exports = __toCommonJS(Meter_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  meterType: 1,
  // Electric
  supportedScales: [0],
  // kWh
  supportedRateTypes: [import_cc.RateType.Consumed],
  supportsReset: true
};
const respondToMeterSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MeterCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Meter, receivedCC.endpointIndex)
      };
      const cc = new import_cc.MeterCCSupportedReport({
        nodeId: controller.ownNodeId,
        type: capabilities.meterType,
        supportedScales: capabilities.supportedScales,
        supportedRateTypes: capabilities.supportedRateTypes,
        supportsReset: capabilities.supportsReset
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMeterGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MeterCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Meter, receivedCC.endpointIndex)
      };
      const scale = receivedCC.scale ?? capabilities.supportedScales[0];
      const rateType = receivedCC.rateType ?? capabilities.supportedRateTypes[0] ?? import_cc.RateType.Consumed;
      const value = capabilities.getValue?.(scale, rateType) ?? {
        value: 0,
        deltaTime: 0
      };
      const normalizedValue = typeof value === "number" ? {
        value,
        deltaTime: 0
      } : value;
      const cc = new import_cc.MeterCCReport({
        nodeId: controller.ownNodeId,
        type: capabilities.meterType,
        scale,
        rateType,
        ...normalizedValue
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMeterReset = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MeterCCReset) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Meter, receivedCC.endpointIndex)
      };
      const cc = receivedCC;
      if (cc.type != void 0 && cc.scale != void 0 && cc.rateType != void 0 && cc.targetValue != void 0) {
        capabilities.onReset?.({
          scale: cc.scale,
          rateType: cc.rateType,
          targetValue: cc.targetValue
        });
      } else {
        capabilities.onReset?.();
      }
      return { action: "ok" };
    }
  }
};
const MeterCCBehaviors = [
  respondToMeterSupportedGet,
  respondToMeterGet,
  respondToMeterReset
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MeterCCBehaviors,
  defaultCapabilities
});
//# sourceMappingURL=Meter.js.map
