"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Notification_exports = {};
__export(Notification_exports, {
  NotificationCCBehaviors: () => NotificationCCBehaviors
});
module.exports = __toCommonJS(Notification_exports);
var import_NotificationCC = require("@zwave-js/cc/NotificationCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  supportsV1Alarm: false,
  notificationTypesAndEvents: {}
  // none
};
const respondToNotificationSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_NotificationCC.NotificationCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Notification, receivedCC.endpointIndex)
      };
      const cc = new import_NotificationCC.NotificationCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportsV1Alarm: capabilities.supportsV1Alarm,
        supportedNotificationTypes: Object.keys(capabilities.notificationTypesAndEvents).map((t) => parseInt(t))
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToNotificationEventSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_NotificationCC.NotificationCCEventSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses.Notification, receivedCC.endpointIndex)
      };
      if (receivedCC.notificationType in capabilities.notificationTypesAndEvents) {
        const cc = new import_NotificationCC.NotificationCCEventSupportedReport({
          nodeId: controller.ownNodeId,
          notificationType: receivedCC.notificationType,
          supportedEvents: capabilities.notificationTypesAndEvents[receivedCC.notificationType]
        });
        return { action: "sendCC", cc };
      }
      return { action: "stop" };
    }
  }
};
const NotificationCCBehaviors = [
  respondToNotificationSupportedGet,
  respondToNotificationEventSupportedGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NotificationCCBehaviors
});
//# sourceMappingURL=Notification.js.map
