"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Security_exports = {};
__export(Security_exports, {
  SecurityCCBehaviors: () => SecurityCCBehaviors,
  SecurityCCHooks: () => SecurityCCHooks
});
module.exports = __toCommonJS(Security_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_testing = require("@zwave-js/testing");
const respondToSchemeGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.SecurityCCSchemeGet) {
      const tempKey = new Uint8Array(16).fill(0);
      self.securityManagers.securityManager = new import_core.SecurityManager({
        ownNodeId: self.id,
        networkKey: tempKey,
        nonceTimeout: 1e5
      });
      const cc = new import_cc.SecurityCCSchemeReport({
        nodeId: controller.ownNodeId
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToS0NonceGet = {
  handleCC(controller, self, receivedCC) {
    const sm0Node = self.securityManagers.securityManager;
    if (!sm0Node)
      return;
    if (receivedCC instanceof import_cc.SecurityCCNonceGet) {
      const nonce = sm0Node.generateNonce(controller.ownNodeId, 8);
      const cc = new import_cc.SecurityCCNonceReport({
        nodeId: controller.ownNodeId,
        nonce
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToNetworkKeySet = {
  async handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.SecurityCCNetworkKeySet) {
      const receivedKey = receivedCC.networkKey;
      self.securityManagers.securityManager.networkKey = receivedKey;
      const response = new import_cc.SecurityCCNetworkKeyVerify({
        nodeId: controller.ownNodeId
      });
      return { action: "sendCC", cc: response };
    }
  }
};
const respondToS0CommandsSupportedGet = {
  async handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.SecurityCCCommandsSupportedGet) {
      const supportedCCs = [...self.implementedCCs.entries()].filter(([cc, info]) => info.secure === true && !(0, import_core.isEncapsulationCC)(cc)).map(([cc]) => cc);
      const response = new import_cc.SecurityCCCommandsSupportedReport({
        nodeId: controller.ownNodeId,
        supportedCCs,
        controlledCCs: [],
        reportsToFollow: 0
      });
      return { action: "sendCC", cc: response };
    }
  }
};
const encapsulateS0CC = {
  async transformIncomingCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.SecurityCCCommandEncapsulation) {
      await receivedCC.mergePartialCCs([], {
        sourceNodeId: controller.ownNodeId,
        __internalIsMockNode: true,
        frameType: "singlecast",
        ...self.encodingContext,
        ...self.securityManagers
      });
      if (receivedCC.encapsulated) {
        return receivedCC.encapsulated;
      }
    }
    return receivedCC;
  },
  async transformResponse(controller, self, receivedCC, response) {
    if (response.action === "sendCC" && receivedCC instanceof import_cc.CommandClass && receivedCC.isEncapsulatedWith(import_core.CommandClasses.Security) && !response.cc.isEncapsulatedWith(import_core.CommandClasses.Security)) {
      const nonceGet = new import_cc.SecurityCCNonceGet({
        nodeId: response.cc.nodeId
      });
      await self.sendToController((0, import_testing.createMockZWaveRequestFrame)(nonceGet, {
        ackRequested: false
      }));
      const nonceReport = await self.expectControllerFrame((resp) => resp.type === import_testing.MockZWaveFrameType.Request && resp.payload instanceof import_cc.SecurityCCNonceReport, { timeout: 1e3 });
      const receiverNonce = nonceReport.payload.nonce;
      const encapsulated = import_cc.SecurityCC.encapsulate(self.id, self.securityManagers.securityManager, response.cc);
      encapsulated.nonce = receiverNonce;
      response.cc = encapsulated;
    }
    return response;
  }
};
const SecurityCCHooks = [
  encapsulateS0CC
];
const SecurityCCBehaviors = [
  respondToSchemeGet,
  respondToS0NonceGet,
  respondToNetworkKeySet,
  respondToS0CommandsSupportedGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SecurityCCBehaviors,
  SecurityCCHooks
});
//# sourceMappingURL=Security.js.map
