import { cloneDeep } from "@zwave-js/shared";
import { StatisticsHost } from "../driver/Statistics.js";
export class ControllerStatisticsHost extends StatisticsHost {
    createEmpty() {
        return {
            messagesTX: 0,
            messagesRX: 0,
            messagesDroppedRX: 0,
            NAK: 0,
            CAN: 0,
            timeoutACK: 0,
            timeoutResponse: 0,
            timeoutCallback: 0,
            messagesDroppedTX: 0,
        };
    }
    transformBeforeEmit(statistics) {
        const ret = cloneDeep(statistics);
        // Apply rounding to background RSSI averages when emitting events
        if (ret.backgroundRSSI) {
            ret.backgroundRSSI.channel0.average = Math.round(ret.backgroundRSSI.channel0.average);
            ret.backgroundRSSI.channel1.average = Math.round(ret.backgroundRSSI.channel1.average);
            if (ret.backgroundRSSI.channel2) {
                ret.backgroundRSSI.channel2.average = Math.round(ret.backgroundRSSI.channel2.average);
            }
            if (ret.backgroundRSSI.channel3) {
                ret.backgroundRSSI.channel3.average = Math.round(ret.backgroundRSSI.channel3.average);
            }
        }
        return ret;
    }
}
//# sourceMappingURL=ControllerStatistics.js.map