import { type SetValueResult } from "@zwave-js/cc";
import { type TranslatedValueID, type ValueID } from "@zwave-js/core";
import { FunctionType, Message } from "@zwave-js/serial";
import type { Driver } from "../../driver/Driver.js";
import type { ZWaveController } from "../Controller.js";
import type { ControllerProprietaryCommon } from "../Proprietary.js";
export declare const FUNC_ID_NABUCASA = FunctionType.Proprietary_F0;
export declare enum NabuCasaCommand {
    GetSupportedCommands = 0,
    GetLED = 1,
    SetLED = 2,
    ReadGyro = 3,
    SetSystemIndication = 4,
    GetConfig = 5,
    SetConfig = 6,
    GetLEDBinary = 7,
    SetLEDBinary = 8
}
export interface RGB {
    r: number;
    g: number;
    b: number;
}
export interface Vector {
    x: number;
    y: number;
    z: number;
}
export declare enum NabuCasaIndicationSeverity {
    None = 0,
    Warning = 1,
    Error = 2
}
export declare enum NabuCasaConfigKey {
    EnableTiltIndicator = 0
}
export declare class ControllerProprietary_NabuCasa implements ControllerProprietaryCommon {
    constructor(driver: Driver, controller: ZWaveController);
    private driver;
    private controller;
    private supportedCommands?;
    interview(): Promise<void>;
    private persistRGBValue;
    private persistLEDState;
    getSupportedCommands(): Promise<NabuCasaCommand[]>;
    getLED(): Promise<RGB>;
    setLED(rgb: RGB): Promise<boolean>;
    getLEDBinary(): Promise<boolean>;
    setLEDBinary(state: boolean): Promise<boolean>;
    readGyro(): Promise<Vector | undefined>;
    setSystemIndication(severity: NabuCasaIndicationSeverity): Promise<boolean>;
    getConfig(key: NabuCasaConfigKey): Promise<number>;
    setConfig(key: NabuCasaConfigKey, value: number): Promise<boolean>;
    getDefinedValueIDs(): TranslatedValueID[];
    pollValue(valueId: ValueID): Promise<unknown>;
    setValue(valueId: ValueID, value: unknown): Promise<SetValueResult>;
    handleUnsolicited(_msg: Message): Promise<boolean>;
}
//# sourceMappingURL=NabuCasa.d.ts.map