/** Mixin to provide statistics functionality. Requires the base class to extend EventEmitter. */
export declare abstract class StatisticsHost<T> {
    protected abstract createEmpty(): T;
    private _statistics;
    get statistics(): Readonly<T>;
    resetStatistics(): void;
    /** Can be overridden in derived classes to specify additional args to be included in the statistics event callback. */
    protected getAdditionalEventArgs(): any[];
    /** Can be overridden in derived classes to specify how to transform the internal statistics before emitting them to applications. */
    protected transformBeforeEmit(statistics: Readonly<T>): T;
    private _emitUpdate;
    updateStatistics(updater: (current: Readonly<T>) => T): void;
    incrementStatistics(property: keyof T): void;
}
export interface StatisticsEventCallbacks<T> {
    "statistics updated": (statistics: Readonly<T>) => void;
}
export interface StatisticsEventCallbacksWithSelf<TSelf, TStats> {
    "statistics updated": (self: TSelf, statistics: Readonly<TStats>) => void;
}
//# sourceMappingURL=Statistics.d.ts.map