/** Handles the receipt of an ApplicationBusy command */
export async function handleApplicationBusy(ctx, driver, node, command) {
    // If the wait time is not included, wait 1 second by default
    const waitTimeSeconds = Math.min(command.waitTime ?? 1, 30);
    ctx.logNode(node.id, {
        message: `Node is busy, re-queueing commands after ${waitTimeSeconds} second(s)...`,
        direction: "inbound",
    });
    await driver.delayTransactionsForNode(node.id, waitTimeSeconds);
}
//# sourceMappingURL=ApplicationStatusCC.js.map