import { BinarySwitchCCSet, BinarySwitchCCValues, } from "@zwave-js/cc";
/** Handles the receipt of a BinarySwitchCC Set */
export function handleBinarySwitchCommand(ctx, node, command) {
    if (command instanceof BinarySwitchCCSet
        && node.deviceConfig?.compat?.treatSetAsReport?.has(command.constructor.name)) {
        ctx.logNode(node.id, {
            endpoint: command.endpointIndex,
            message: "treating BinarySwitchCC::Set as a report",
        });
        node.valueDB.setValue(BinarySwitchCCValues.currentValue.endpoint(command.endpointIndex), command.targetValue);
    }
}
//# sourceMappingURL=BinarySwitchCC.js.map