import { CommandClasses, EncapsulationFlags, } from "@zwave-js/core";
export async function handleManufacturerSpecificGet(ctx, node, command, vendorInfo) {
    // We are being queried, so the device may actually not support the CC, just control it.
    // Using the commandClasses property would throw in that case
    const api = node
        .createAPI(CommandClasses["Manufacturer Specific"], false)
        .withOptions({
        // Answer with the same encapsulation as asked, but omit
        // Supervision as it shouldn't be used for Get-Report flows
        encapsulationFlags: command.encapsulationFlags
            & ~EncapsulationFlags.Supervision,
    });
    await api.sendReport({
        // Reserved manufacturer ID, definitely invalid!
        manufacturerId: vendorInfo?.manufacturerId ?? 0xffff,
        productType: vendorInfo?.productType ?? 0xffff,
        productId: vendorInfo?.productId ?? 0xffff,
    });
}
//# sourceMappingURL=ManufacturerSpecificCC.js.map