import { type NotificationCCReport, type PersistValuesContext } from "@zwave-js/cc";
import { type GetSupportedCCVersion, type LogNode, type NodeId, type Notification } from "@zwave-js/core";
import { type Timer } from "@zwave-js/shared";
import type { ZWaveNode } from "../Node.js";
import type { NodeValues } from "../mixins/40_Values.js";
export interface NotificationHandlerStore {
    idleTimeouts: Map<string, Timer>;
}
export declare function getDefaultNotificationHandlerStore(): NotificationHandlerStore;
/** Handles the receipt of a Notification Report */
export declare function handleNotificationReport(ctx: PersistValuesContext & LogNode, node: ZWaveNode, command: NotificationCCReport, store: NotificationHandlerStore): void;
/** Manually resets a single notification value to idle */
export declare function manuallyIdleNotificationValueInternal(ctx: GetSupportedCCVersion, node: NodeId & NodeValues, store: NotificationHandlerStore, notification: Notification, prevValue: number, endpointIndex: number): void;
//# sourceMappingURL=NotificationCC.d.ts.map