import { CommandClasses, EncapsulationFlags, getDSTInfo, } from "@zwave-js/core";
export async function handleTimeGet(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    const now = new Date();
    const hours = now.getHours();
    const minutes = now.getMinutes();
    const seconds = now.getSeconds();
    try {
        // We are being queried, so the device may actually not support the CC, just control it.
        // Using the commandClasses property would throw in that case
        const api = endpoint
            .createAPI(CommandClasses.Time, false)
            .withOptions({
            // Answer with the same encapsulation as asked, but omit
            // Supervision as it shouldn't be used for Get-Report flows
            encapsulationFlags: command.encapsulationFlags
                & ~EncapsulationFlags.Supervision,
        });
        await api.reportTime(hours, minutes, seconds);
    }
    catch (e) {
        ctx.logNode(node.id, {
            message: e.message,
            level: "error",
        });
        // ignore
    }
}
export async function handleDateGet(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    const now = new Date();
    const year = now.getFullYear();
    const month = now.getMonth() + 1;
    const day = now.getDate();
    try {
        // We are being queried, so the device may actually not support the CC, just control it.
        // Using the commandClasses property would throw in that case
        const api = endpoint
            .createAPI(CommandClasses.Time, false)
            .withOptions({
            // Answer with the same encapsulation as asked, but omit
            // Supervision as it shouldn't be used for Get-Report flows
            encapsulationFlags: command.encapsulationFlags
                & ~EncapsulationFlags.Supervision,
        });
        await api.reportDate(year, month, day);
    }
    catch (e) {
        ctx.logNode(node.id, {
            message: e.message,
            level: "error",
        });
        // ignore
    }
}
export async function handleTimeOffsetGet(ctx, node, command) {
    const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
    const timezone = getDSTInfo(new Date());
    try {
        // We are being queried, so the device may actually not support the CC, just control it.
        // Using the commandClasses property would throw in that case
        const api = endpoint
            .createAPI(CommandClasses.Time, false)
            .withOptions({
            // Answer with the same encapsulation as asked, but omit
            // Supervision as it shouldn't be used for Get-Report flows
            encapsulationFlags: command.encapsulationFlags
                & ~EncapsulationFlags.Supervision,
        });
        await api.reportTimezone(timezone);
    }
    catch {
        // ignore
    }
}
//# sourceMappingURL=TimeCC.js.map