import { NOT_KNOWN, Protocols, isLongRangeNodeId, } from "@zwave-js/core";
import { cacheKeys } from "../../driver/NetworkCache.js";
import { ZWaveNodeBase } from "./00_Base.js";
export class NetworkRoleMixin extends ZWaveNodeBase {
    get isListening() {
        return this.driver.cacheGet(cacheKeys.node(this.id).isListening);
    }
    set isListening(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).isListening, value);
    }
    get isFrequentListening() {
        return this.driver.cacheGet(cacheKeys.node(this.id).isFrequentListening);
    }
    set isFrequentListening(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).isFrequentListening, value);
    }
    get canSleep() {
        // The controller node can never sleep (apparently it can report otherwise though)
        if (this.isControllerNode)
            return false;
        if (this.isListening == NOT_KNOWN)
            return NOT_KNOWN;
        if (this.isFrequentListening == NOT_KNOWN)
            return NOT_KNOWN;
        return !this.isListening && !this.isFrequentListening;
    }
    get isRouting() {
        return this.driver.cacheGet(cacheKeys.node(this.id).isRouting);
    }
    set isRouting(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).isRouting, value);
    }
    get supportedDataRates() {
        return this.driver.cacheGet(cacheKeys.node(this.id).supportedDataRates);
    }
    set supportedDataRates(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).supportedDataRates, value);
    }
    get maxDataRate() {
        if (this.supportedDataRates) {
            return Math.max(...this.supportedDataRates);
        }
    }
    get protocolVersion() {
        return this.driver.cacheGet(cacheKeys.node(this.id).protocolVersion);
    }
    set protocolVersion(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).protocolVersion, value);
    }
    get nodeType() {
        return this.driver.cacheGet(cacheKeys.node(this.id).nodeType);
    }
    set nodeType(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).nodeType, value);
    }
    get supportsSecurity() {
        return this.driver.cacheGet(cacheKeys.node(this.id).supportsSecurity);
    }
    set supportsSecurity(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).supportsSecurity, value);
    }
    get supportsBeaming() {
        return this.driver.cacheGet(cacheKeys.node(this.id).supportsBeaming);
    }
    set supportsBeaming(value) {
        this.driver.cacheSet(cacheKeys.node(this.id).supportsBeaming, value);
    }
    get protocol() {
        return isLongRangeNodeId(this.id)
            ? Protocols.ZWaveLongRange
            : Protocols.ZWave;
    }
    get isControllerNode() {
        return this.id === this.driver.controller.ownNodeId;
    }
}
//# sourceMappingURL=01_NetworkRole.js.map