import type { SchedulePollOptions } from "@zwave-js/cc";
import { type CommandClasses, type ValueDB, type ValueID } from "@zwave-js/core";
import { type Timer } from "@zwave-js/shared";
import type { Driver } from "../../driver/Driver.js";
import type { DeviceClass } from "../DeviceClass.js";
import { EndpointsMixin } from "./50_Endpoints.js";
export interface ScheduledPoll {
    timeout: Timer;
    expectedValue?: unknown;
}
/** Defines functionality of Z-Wave nodes for scheduling polls for a later time and canceling scheduled polls */
export interface NodeSchedulePoll {
}
export declare abstract class SchedulePollMixin extends EndpointsMixin implements NodeSchedulePoll {
    constructor(nodeId: number, driver: Driver, endpointIndex: number, deviceClass?: DeviceClass, supportedCCs?: CommandClasses[], valueDB?: ValueDB);
    /**
     * All polls that are currently scheduled for this node
     */
    private _scheduledPolls;
    hasScheduledPolls(): boolean;
    schedulePoll(valueId: ValueID, options?: SchedulePollOptions): boolean;
    cancelScheduledPoll(valueId: ValueID, actualValue?: unknown): boolean;
    cancelAllScheduledPolls(): void;
}
//# sourceMappingURL=60_ScheduledPoll.d.ts.map