import { ManufacturerSpecificCCGet, ManufacturerSpecificCCReport, } from "@zwave-js/cc/ManufacturerSpecificCC";
const respondToManufacturerSpecificGet = {
    handleCC(controller, self, receivedCC) {
        if (receivedCC instanceof ManufacturerSpecificCCGet) {
            const cc = new ManufacturerSpecificCCReport({
                nodeId: controller.ownNodeId,
                manufacturerId: self.capabilities.manufacturerId,
                productType: self.capabilities.productType,
                productId: self.capabilities.productId,
            });
            return { action: "sendCC", cc };
        }
    },
};
export const ManufacturerSpecificCCBehaviors = [
    respondToManufacturerSpecificGet,
];
//# sourceMappingURL=ManufacturerSpecific.js.map